--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Money
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local menu = {}
local x=0
local y=0

local function BumpMoney(n)
	gSim:AdjustMoney(n)
	gSim:Message(bsgDollars(n))
	Pause(1)
end

local function CloseMenu()
	gSim:FlushMessages()
	CloseWindow()
end

table.insert(menu, DevMenuItem { x=0,y=y, w=65, label="#-CLOSE-", command=CloseMenu })
y = y + bsgFontHeight(devfont) + 2
table.insert(menu, DevMenuItem { x=0,y=y, w=65, label="#$1k", command=function() BumpMoney(1000) CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2
table.insert(menu, DevMenuItem { x=0,y=y, w=65, label="#$10k", command=function() BumpMoney(10000) CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2
table.insert(menu, DevMenuItem { x=0,y=y, w=65, label="#$100k", command=function() BumpMoney(100000) CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2
table.insert(menu, DevMenuItem { x=0,y=y, w=65, label="#$1mil", command=function() BumpMoney(1000000) CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2
table.insert(menu, DevMenuItem { x=0,y=y, w=65, label="#$990mil", command=function() BumpMoney(990000000) CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2
table.insert(menu, DevMenuItem { x=0,y=y, w=65, label="#lose $1k", command=function() BumpMoney(-1000) end })
y = y + bsgFontHeight(devfont) + 2
	
-------------------------------------------------------------------------------

x = gDialogTable.x or 0
y = gDialogTable.y or 0

MakeDialog
{
	Rectangle
	{
		x=x,y=y, color=devBackgroundColor, alpha=devAlpha, inset=3,
		Group(menu),
	}
}
